<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateParticipantDateTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('participant_date', function (Blueprint $table) {
            $table->id();
            $table->foreignId('participant_id');
            $table->foreignId('schedule_id');
            $table->foreignId('schedule_date_id');
            $table->enum('participant_status',['0','1','2']);
            $table->timestamps();

            //$table->foreign('participant_id')->references('id')->on('participants');
            //$table->foreign('schedule_id')->references('id')->on('schedules');
            //$table->foreign('schedule_date_id')->references('id')->on('schedule_dates');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('participant_date');
    }
}
